<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $db, $app_strings, $mod_strings, $theme;

// 🔐 Restrict to Admin / specific users
$allowedUsers = ['admin', 'System Administrator']; 
if(!$current_user->is_admin && !in_array($current_user->user_name, $allowedUsers)) {
    sugar_die("❌ You do not have permission to view this report.");
}

// 📅 Filters
$minutes = isset($_REQUEST['minutes']) ? intval($_REQUEST['minutes']) : 10;
$startDate = !empty($_REQUEST['start']) ? $_REQUEST['start'] . " 00:00:00" : date('Y-m-d 00:00:00');
$endDate   = !empty($_REQUEST['end'])   ? $_REQUEST['end']   . " 23:59:59" : date('Y-m-d 23:59:59');

// 📝 Query
$sql = "
SELECT 
    c.id,
    c.first_name,
    c.last_name,
    c.date_entered,
    MIN(cal.date_start) AS first_call_date,
    -- if no call, use NOW() instead of first_call_date
    TIMESTAMPDIFF(
        MINUTE, 
        c.date_entered, 
        COALESCE(MIN(cal.date_start), NOW())
    ) AS delay_minutes
FROM contacts c
LEFT JOIN calls_contacts cc 
    ON cc.contact_id = c.id AND cc.deleted = 0
LEFT JOIN calls cal 
    ON cal.id = cc.call_id AND cal.deleted = 0
WHERE c.deleted = 0
  AND c.date_entered BETWEEN '{$startDate}' AND '{$endDate}'
  AND (c.first_name IS NOT NULL)
GROUP BY c.id
HAVING delay_minutes > {$minutes}
ORDER BY delay_minutes DESC
";
$res = $db->query($sql);

// Collect results
$rows = [];
while($row = $db->fetchByAssoc($res)) {
    $rows[] = $row;
}

// Use Smarty for SuiteCRM theme
require_once('include/Sugar_Smarty.php');
$smarty = new Sugar_Smarty();

$smarty->assign('APP', $app_strings);
$smarty->assign('MOD', $mod_strings);
$smarty->assign('THEME', $theme);
$smarty->assign('MINUTES', $minutes);
$smarty->assign('START', substr($startDate,0,10));
$smarty->assign('END', substr($endDate,0,10));
$smarty->assign('ROWS', $rows);

// Display
$smarty->display('custom/tpls/reportDelay.tpl');