<?php

namespace App\Custom\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

class ContactApiController extends AbstractController
{
    /**
     * Create Contact API
     * Example:
     * /crm/public/index.php/custom-api/create-contact?username=John&lastname=Doe&phone=01234
     */
    public function createContact(Request $request): JsonResponse
    {
        $username = $request->query->get('username');
        $lastname = $request->query->get('lastname');
        $phone    = $request->query->get('phone');

        if (!$username || !$lastname) {
            return new JsonResponse(['error' => 'Missing required fields'], 400);
        }

        // Load SuiteCRM legacy
        require_once __DIR__ . '/../../../legacy/include/entryPoint.php';

        // Create new Contact bean
        $contact = \BeanFactory::newBean('Contacts');
        $contact->first_name   = $username;
        $contact->last_name    = $lastname;
        $contact->phone_mobile = $phone;
        $contact->call_status_c = "Haven't Called"; // custom field (must exist in Studio)
        $contact->tag_c        = "Hot";             // custom field (must exist)

        $contact->save();

        return new JsonResponse([
            'success' => true,
            'id'      => $contact->id,
        ]);
    }

    /**
     * Update Contact API
     * Example:
     * /crm/public/index.php/custom-api/update-contact?username=John
     */
    public function updateContact(Request $request): JsonResponse
    {
        $username = $request->query->get('username');

        if (!$username) {
            return new JsonResponse(['error' => 'Missing username'], 400);
        }

        // Load SuiteCRM legacy
        require_once __DIR__ . '/../../../legacy/include/entryPoint.php';

        $contactBean = \BeanFactory::newBean('Contacts');
        $contacts = $contactBean->get_full_list(
            '', "contacts.first_name = '{$username}'"
        );

        if (empty($contacts)) {
            return new JsonResponse(['error' => 'Contact not found'], 404);
        }

        $contact = $contacts[0];
        $contact->call_status_c = "Deposit Done"; // custom field
        $contact->tag_c         = "VIP";          // custom field

        $contact->save();

        return new JsonResponse([
            'success' => true,
            'id'      => $contact->id,
        ]);
    }
}
