<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class crep_ContactsController extends SugarController
{
    public function action_delayreport()
    {
        global $current_user, $app_strings, $mod_strings, $theme;

        // Restrict access to Admin or specific users
        $allowedUsers = ['admin', 'System Administrator'];
        if (!$current_user->is_admin && !in_array($current_user->user_name, $allowedUsers)) {
            sugar_die("❌ You do not have permission to view this report.");
        }

        // Get filters
        $minutes = isset($_REQUEST['minutes']) ? intval($_REQUEST['minutes']) : 10;
        $startDate = !empty($_REQUEST['start']) ? $_REQUEST['start'] : date('Y-m-d');
        $endDate = !empty($_REQUEST['end']) ? $_REQUEST['end'] : date('Y-m-d');

        // Fetch data
        require_once('modules/crep_Contacts/crep_Contacts.php');
        $contactBean = new crep_Contacts();
        $rows = $contactBean->getDelayReportData($minutes, $startDate, $endDate);

        // Assign to Smarty
        require_once('include/Sugar_Smarty.php');
        $smarty = new Sugar_Smarty();
        $smarty->assign('APP', $app_strings);
        $smarty->assign('MOD', $mod_strings);
        $smarty->assign('THEME', $theme);
        $smarty->assign('MINUTES', $minutes);
        $smarty->assign('START', $startDate);
        $smarty->assign('END', $endDate);
        $smarty->assign('ROWS', $rows);

        // Display
        $smarty->display('modules/crep_Contacts/tpls/DelayReport.tpl');
    }
}