<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

/*
class crep_Contacts extends Basic
{
    public $new_schema = true;
    public $module_dir = 'crep_Contacts';
    public $object_name = 'crep_Contacts';
    public $table_name = 'crep_contacts';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
	
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }
	
}
*/

<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class crep_Contacts extends Basic
{
    public $new_schema = true;
    public $module_dir = 'crep_Contacts';
    public $object_name = 'crep_Contacts';
    public $table_name = 'crep_contacts';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }
        return false;
    }

    // Custom method to fetch Contact Call Delay Report data
    public function getDelayReportData($minutes = 10, $startDate = '', $endDate = '')
    {
        global $db;

        $startDate = !empty($startDate) ? $db->quote($startDate . " 00:00:00") : date('Y-m-d 00:00:00');
        $endDate = !empty($endDate) ? $db->quote($endDate . " 23:59:59") : date('Y-m-d 23:59:59');

        $sql = "
            SELECT 
                c.id,
                c.first_name,
                c.last_name,
                c.date_entered,
                MIN(cal.date_start) AS first_call_date,
                TIMESTAMPDIFF(
                    MINUTE, 
                    c.date_entered, 
                    COALESCE(MIN(cal.date_start), NOW())
                ) AS delay_minutes
            FROM contacts c
            LEFT JOIN calls_contacts cc 
                ON cc.contact_id = c.id AND cc.deleted = 0
            LEFT JOIN calls cal 
                ON cal.id = cc.call_id AND cal.deleted = 0
            WHERE c.deleted = 0
              AND c.date_entered BETWEEN '{$startDate}' AND '{$endDate}'
            GROUP BY c.id
            HAVING delay_minutes > {$minutes}
            ORDER BY delay_minutes DESC
        ";

        $res = $db->query($sql);
        $rows = [];
        while ($row = $db->fetchByAssoc($res)) {
            $rows[] = $row;
        }
        return $rows;
    }
}