<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $db;

// 🔐 Access Control
$allowedUsers = ['System Administrator','admin']; // Add usernames here
if(!$current_user->is_admin && !in_array($current_user->user_name, $allowedUsers)) {
    sugar_die("❌ You do not have permission to view this report.");
}

// 📅 Get filters
$minutes = isset($_REQUEST['minutes']) ? intval($_REQUEST['minutes']) : 10;
$startDate = !empty($_REQUEST['start']) ? $_REQUEST['start'] : date('Y-m-d 00:00:00');
$endDate   = !empty($_REQUEST['end']) ? $_REQUEST['end'] : date('Y-m-d 23:59:59');

// 📝 Query: Contacts with first call delay > X minutes
$sql = "
SELECT c.id, c.first_name, c.last_name, c.date_entered,
       MIN(cal.date_start) AS first_call_date,
       TIMESTAMPDIFF(MINUTE, c.date_entered, MIN(cal.date_start)) AS delay_minutes
FROM contacts c
LEFT JOIN calls_contacts cc ON cc.contact_id = c.id AND cc.deleted = 0
LEFT JOIN calls cal ON cal.id = cc.call_id AND cal.deleted = 0
WHERE c.deleted = 0
  AND c.date_entered BETWEEN '{$startDate}' AND '{$endDate}'
GROUP BY c.id
HAVING delay_minutes > {$minutes} OR first_call_date IS NULL
ORDER BY delay_minutes DESC
";

$res = $db->query($sql);

// 📊 Output simple HTML table
echo "<h2>Contact Call Delay Report</h2>";
echo "<p>Showing contacts created between <b>{$startDate}</b> and <b>{$endDate}</b> with delay > {$minutes} minutes.</p>";
echo "<table border='1' cellpadding='5' cellspacing='0'>
<tr><th>Contact</th><th>Created</th><th>First Call</th><th>Delay (mins)</th></tr>";

while($row = $db->fetchByAssoc($res)) {
    echo "<tr>
        <td><a href='index.php?module=Contacts&action=DetailView&record={$row['id']}'>{$row['first_name']} {$row['last_name']}</a></td>
        <td>{$row['date_entered']}</td>
        <td>".($row['first_call_date'] ?? '❌ No Call')."</td>
        <td>".($row['delay_minutes'] ?? 'N/A')."</td>
    </tr>";
}
echo "</table>";
